﻿<%

'--------------------------------------------
' 名称：MakeHtmlPage()
' 作用：生成一篇静态日志
'--------------------------------------------
Function MakeHtmlPage()
	Dim objStream,Fso,HTMLPageNum,HTMLPageName,HTMLPage,ArticleID
	Set Fso = Server.CreateObject("Scripting.FileSystemObject")
	HTMLPageNum = 1
	HTMLPageName = ""
	Do While HTMLPageName = ""
		If Fso.FileExists(Server.MapPath("Article/" & Date & "-" & HTMLPageNum & ".html")) Then
			HTMLPageNum = HTMLPageNum + 1
		Else
			HTMLPageName = "Article/" & Date & "-" & HTMLPageNum & ".html"
		End If
	Loop
	Set Fso = Nothing
	'Head 部分
	HTMLPage = 	Show_Head()
	'菜单部分
	HTMLPage = 	HTMLPage + Show_Menu()
	'公告部分
	HTMLPage =  HTMLPage + Show_Main_Announcement()
	'文章部分
	HTMLPage = 	HTMLPage + Show_Main_Article()
	'评论部分
	HTMLPage = 	HTMLPage + "$Show_Main_Comment$"
	'编辑器部分
	HTMLPage =  HTMLPage + Show_Main_CommentEditor()
	'边栏部分
	HTMLPage =  HTMLPage + Show_SideBar()
	'Foot 部分
	HTMLPage =  HTMLPage + Show_Foot()
	ArticleID = rs("ID")
	rs.Close
	sql = "select * from " & PrefixStr & "Comment where ArticleID=" & ArticleID & " order by CID desc"
	rs.Open sql,conn,1,3
	ArticleID = Show_Main_Comment()
	HTMLPage = 	Replace(HTMLPage,"$Show_Main_Comment$",ArticleID)

	'生成静态页面，这里不能用 Fso，Fso 不能生成 UTF-8 编码的文件
	Set objStream = Server.CreateObject("ADODB.Stream")
    With objStream
    .Open
    .Charset = "utf-8"           '编码，这里你可以改成任何编码
    .Position = objStream.Size
    .WriteText = HTMLPage        '模版+数据
    .SaveToFile Server.MapPath(HTMLPageName), 2   '生成文件路径
    .Close
    End With
	Set objStream = Nothing
	MakeHtmlPage = HTMLPageName
End Function

'--------------------------------------------
' 名称：Show_Head()
' 参数：无
' 返回：Head
' 作用：返回文章头
'--------------------------------------------
Function Show_Head()
	Dim Head
	Head = 	"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>"
	Head = 	Head + "<html xmlns='http://www.w3.org/1999/xhtml' lang='zh-cn'>"
	Head = 	Head + "<head>"
	Head = 	Head + "<meta http-equiv = 'Content-Type' content = 'text/html; charset=UTF-8' />"
	Head = 	Head + "<meta http-equiv = 'Content-Language' content = 'UTF-8' />"
	Head = 	Head + "<meta content = 'all' name = 'robots' />"
	Head = 	Head + "<meta name = 'author' content = '" & Application("BlogName") & "' />"
	Head = 	Head + "<meta name = 'description' content = '" & Application("BlogDescription") & "' />"
	Head = 	Head + "<meta name = 'keywords' content = '" & Application("BlogKeyWords") & "' />"
	Head = 	Head + "<title>" & rs("Title") & " - " & Application("BlogName") & " - " & Application("BlogDescription") & " - " & Application("BlogKeyWords") & "</title>"
	Head = 	Head + "<link rel = 'stylesheet' href = '../Style/" & Application("BlogStyle") & "/style.css' type = 'text/css' />"
	Head = 	Head + "<script type = 'text/JavaScript' src = '../Js/common.js'></script>"
	Head = 	Head + "<script src='../Include/Count.asp?id=" & rs("ID") & "'></script>"
	Head = 	Head + "</head>"
	Head = 	Head + "<body><div id = 'body'><div id = 'Head'><div id = 'Head_Name'><h1><a href='" & Application("BlogDomain") & "'>" & Application("BlogName") & "</a></h1><p>" & Application("BlogDescription") & "</p></div></div>"
	Show_Head = Head
End Function

'--------------------------------------------
' 名称：Show_Menu()
' 参数：无
' 返回：Menu
' 作用：返回导航菜单
'--------------------------------------------
Function Show_Menu()
	Dim Menu
	Menu = 	"<div id = 'MenuBox'>"
	Menu = 	Menu + "<div id = 'Menu_Menu'><ul class='Menu_Menu'><li><a href='../' title='日志'>日志</a></li><li><a href='../GuestBook.asp' title='留言本'>留言本</a></li></ul>"
	Menu = 	Menu + "<div id = 'Menu_Search'><form method='get' id='Menu_SearchForm' action='../Search.asp'><div><input class='Menu_SearchInput' type='text' value='搜·" & Application("BlogName") & "！' name='s' id='s' /><input class='Menu_SearchBtn' type='submit' value='' id='searchsubmit' /></div></form></div></div></div>"
	Show_Menu = Menu
End Function

'--------------------------------------------
' 名称：Show_Main_Announcement()
' 参数：无
' 返回：Announcement
' 作用：返回公告
'--------------------------------------------
Function Show_Main_Announcement()
	Dim Announcement
	Announcement = "<div id ='MainBox_Top'><div><div id = 'MainBox'><div id = 'Main'>"
	Announcement = 	Announcement + "<div id = 'Main_Announcement'><marquee onmouseover='this.stop()' onmouseout='this.start()' scrollamount='1' scrolldelay='15' direction='up' height='50'><font color='#999999'>[08-10-01]</font>星空工作室(XKLab)公开声明</a><br /><font color='#999999'>[08-10-01]</font>本站所有文章除注明外均为原创，转载请注明出处。<br /><font color='#999999'>[08-10-01]</font>本站所有文章仅供学习交流，请大家自觉遵守国家的法律法规，否则一切后果与星空工作室无关。<br /></marquee></div>"
	Show_Main_Announcement = Announcement
End Function

'--------------------------------------------
' 名称：Show_Main_Article()
' 参数：无
' 返回：Article
' 作用：返回文章
'--------------------------------------------
Function Show_Main_Article()
	Dim Article,ArticleDate,ArticleTime,Content,Similar
	ArticleTime = rs("Date")
	ArticleDate = "<h2>" & Right(ArticleTime,(Len(ArticleTime) - InStrRev(ArticleTime,"-"))) & "</h2><h5>" & Left(ArticleTime,InStrRev(ArticleTime,"-")-1) & "</h5>"
	Content = Replace(rs("Content"),"[showall]","")
	Article = "<div class = 'Main_Article'><div class = 'Main_Article_Head'>"
	Article = Article + "<div class = 'Main_Article_Date'>" & ArticleDate & "</div>"
	Article = Article + "<div class = 'Main_Article_Title'><h2>" & rs("Title") & "</h2></div>"
	Article = Article + "<div class = 'Main_Article_TopInfo'>作者：" & rs("Author") & " | 分类：" & rs("Class") & " | 时间：" & ArticleTime & " " & rs("Time") & "</div></div>"
	Article = Article + "<div class = 'Main_Article_Content'>" & Content & "</div>"
	If rs("Tag") <> "" Then
		Article = Article + "<div class = 'Main_Article_Tag'>标签：" & rs("Tag") & "</div>"
		
		Article = Article + "<div class = 'Main_Article_Similar'>" & Similar & "</div>"
	End If
	Article = Article + "<div class = 'Main_Article_BottomInfo'><a href = '../Read.asp?id=" & rs("ID") & "'>查看动态页面</a> | 阅读：" & rs("Read") & " | 评论：" & rs("Comment") & "</div></div>"
	Show_Main_Article = Article
End Function

'--------------------------------------------
' 名称：Show_Main_Comment()
' 参数：无
' 返回：Comment
' 作用：分页返回评论
'--------------------------------------------
Function Show_Main_Comment()
	Dim Comment
	Comment = ""
	If rs.eof And rs.bof Then
		Comment = Comment + "<div class = 'Main_Comment'>暂无评论。</div>"
	Else
		Do While Not rs.eof
			Comment = Comment + Show_Main_Comment_Content()
			rs.MoveNext
		Loop
	End If
	Show_Main_Comment = Comment
End Function

'--------------------------------------------
' 名称：Show_Main_Comment_Content()
' 参数：无
' 返回：Comment
' 作用：返回评论
'--------------------------------------------
Function Show_Main_Comment_Content()
	Dim Comment
		Comment = "<div class = 'Main_Comment'>"
		Comment = Comment + "<div class = 'Main_Comment_Title'><b>" & rs("Author") & "</b> 写于 [" & rs("Date") & " " & rs("Time") & "]</div>"
		Comment = Comment + "<div class = 'Main_Comment_Content'>" & rs("Comment") & "</div>"
		If rs("Reply") <> "" Then
			Comment = Comment + "<div class = 'Main_Comment_Reply'>"
			Comment = Comment + "<div class = 'Main_Comment_Reply_Title'><b>" & rs("ReplyUser") & "</b> 回复于 [" & rs("ReplyDate") & " " & rs("ReplyTime") & "]</div>"
			Comment = Comment + "<div class = 'Main_Comment_Reply_Content'>" & rs("Reply") & "</div></div>"
		End If
		Comment = Comment + "</div>"
	Show_Main_Comment_Content = Comment
End Function

'--------------------------------------------
' 名称：Show_Main_CommentEditor()
' 参数：无
' 返回：CommentEditor
' 作用：返回编辑器
'--------------------------------------------
Function Show_Main_CommentEditor()
	Dim CommentEditor
	CommentEditor = "<div id = 'Main_CommentEditor'><form action='../Read.asp?id=" & rs("ID") & "&action=1' method='post' name='comment' id='comment'><ul>"
	CommentEditor = CommentEditor + "<li>昵称：<input name='UserName' type='text' size='14' maxlength='20' /></li>"
	CommentEditor = CommentEditor + "<li>邮箱：<input name='Email' type='text' size='20' maxlength='50' /> (可不填,保密)</li>"
	CommentEditor = CommentEditor + "<li>网址：<input name='WebIndex' type='text' size='20' maxlength='50' /> (可不填)</li>"
	CommentEditor = CommentEditor + "<li> Q Q ：<input name='QQ' type='text' size='10' maxlength='10' /> (可不填)</li>"
	CommentEditor = CommentEditor + "<li>内容：</li>"
	CommentEditor = CommentEditor + "<li><textarea name='Comment' cols='90' rows='6'></textarea></li>"
	CommentEditor = CommentEditor + "<li>验证码：<input name='CheckCode' type='text' size='6' maxlength='10' /><img src='../Inc/CheckCode.asp' align='absmiddle' /></li>"
	CommentEditor = CommentEditor + "<li><input type='submit' name='Submit' value=' 立即发表 ' /></li></ul></form></div></div>"
	Show_Main_CommentEditor = CommentEditor
End Function

'--------------------------------------------
' 名称：Show_SideBar()
' 参数：无
' 返回：SideBar
' 作用：返回边栏
'--------------------------------------------
Function Show_SideBar()
	Dim SideBar
	SideBar = "<div id = 'SideBar'>"
	SideBar = SideBar + "<div id = 'SideBar_A'>"
	SideBar = SideBar + "<div id = 'SideBar_A_Self'></div>"
	SideBar = SideBar + Show_SideBar_ArticleClass()
	SideBar = SideBar + Show_SideBar_NewArticle()
	SideBar = SideBar + Show_SideBar_RandomArticle()
	SideBar = SideBar + Show_SideBar_Comment()
	SideBar = SideBar + Show_SideBar_GuestBook()
	SideBar = SideBar + "</div><div id = 'SideBar_B'><div id = 'SideBar_B_Self'></div>"
	SideBar = SideBar + Show_SideBar_Link()
	SideBar = SideBar + Show_SideBar_SiteCount()
	SideBar = SideBar + "</div></div></div>"
	Show_SideBar = SideBar
End Function

'--------------------------------------------
' 名称：Show_SideBar_ArticleClass()
' 参数：无
' 返回：SideBar_ArticleClass
' 作用：返回日志分类面板
'--------------------------------------------
Function Show_SideBar_ArticleClass()
	Show_SideBar_ArticleClass = "<div id = 'SideBar_ArticleClass'><h2>日志分类</h2><ul><li>-</li></ul></div>"
End Function

'--------------------------------------------
' 名称：Show_SideBar_NewArticle()
' 参数：无
' 返回：SideBar_NewArticle
' 作用：返回最新日志面板
'--------------------------------------------
Function Show_SideBar_NewArticle()
	Show_SideBar_NewArticle = "<div id = 'SideBar_NewArticle'><h2>最新日志</h2><ul><li>-</li></ul></div>"
End Function

'--------------------------------------------
' 名称：Show_SideBar_RandomArticle()
' 参数：无
' 返回：SideBar_RandomArticle
' 作用：返回随机日志面板
'--------------------------------------------
Function Show_SideBar_RandomArticle()
	Show_SideBar_RandomArticle = "<div id = 'SideBar_RandomArticle'><h2>随机日志</h2><ul><li>-</li></ul></div>"
End Function

'--------------------------------------------
' 名称：Show_SideBar_Comment()
' 参数：无
' 返回：SideBar_Comment
' 作用：返回最新评论面板
'--------------------------------------------
Function Show_SideBar_Comment()
	Show_SideBar_Comment = "<div id = 'SideBar_Comment'><h2>最新评论</h2><ul><li>-</li></ul></div>"
End Function

'--------------------------------------------
' 名称：Show_SideBar_GuestBook()
' 参数：无
' 返回：SideBar_GuestBook
' 作用：返回最新留言面板
'--------------------------------------------
Function Show_SideBar_GuestBook()
	Show_SideBar_GuestBook = "<div id = 'SideBar_GuestBook'><h2>最新留言</h2><ul><li>-</li></ul></div>"
End Function

'--------------------------------------------
' 名称：Show_SideBar_Link()
' 参数：无
' 返回：SideBar_Link
' 作用：返回友情链接面板
'--------------------------------------------
Function Show_SideBar_Link()
	Show_SideBar_Link = "<div id = 'SideBar_Link'><h2>友情链接</h2><ul><li>-</li></ul></div>"
End Function

'--------------------------------------------
' 名称：Show_SideBar_SiteCount()
' 参数：无
' 返回：SideBar_SiteCount
' 作用：返回网站统计面板
'--------------------------------------------
Function Show_SideBar_SiteCount()
	Dim SideBar_SiteCount
	SideBar_SiteCount = "<div id = 'SideBar_SiteCount'><h2>博客统计</h2><ul>"
	SideBar_SiteCount = SideBar_SiteCount + "<li>建站：" & Application("SideBuildDate") & "</li><li>日志：" & Application("SideArticleNum") & "篇</li><li>评论：" & Application("SideCommentNum") & "篇</li>"
	SideBar_SiteCount = SideBar_SiteCount + "<li>留言：" & Application("SideGuestbookNum") & "篇</li><li>访问：" & Application("SideVisitNum") & "次</li><li>用户：" & Application("SideUserNum") & "人</li></ul></div>"
	Show_SideBar_SiteCount = SideBar_SiteCount
End Function

'--------------------------------------------
' 名称：Show_Foot()
' 参数：无
' 返回：Foot
' 作用：返回文件尾部
'--------------------------------------------
Function Show_Foot()
	Dim Foot
	Foot = "<div id ='MainBox_Bottom'></div><div id = 'Foot'><div id = 'Foot_Main'>"
	Foot = Foot + "<div id = 'Foot_Main_Copyright'>Powered By <a href='http://www.xklab.cn/' title = 'XKLog V" & Application("BlogVersion") & " target = '_blank'>XKLog V" & Application("BlogVersion") & "</a> | Designed By " & Application("BlogDesigner") & " | <a href = 'http://www.miibeian.gov.cn' target = '_blank'>" & Application("BlogBeiAn") & "</a></div>"
	Foot = Foot + "<div id = 'Foot_Main_RunTime'>本页最近更新：" & Now() & "</div></div></div></div></body></html>"
	Show_Foot = Foot
End Function

'Function HTMLCreate(ArticleID)

'HTMLDelete(ArticleID)
'HTML
'HTML
%>